/**********************************************************************************************************************
 * Plotter Controll v82
 **********************************************************************************************************************
 * Wolfgang Spahn
 * 23-okt-2014
 * 
 * Firmata for an XY plotter with two tools. On the left side a chalk and on the right a sponge
 * 
 * The zero point is the left down corner. X is right. Y is up.
 *
 * - Stepper Motor Control over Serial Input
 * - Home and End Switch integrated
 * - Chalk Motor (two directions)
 * - Sponge Rotation Motors
 * - Distance Chalk and Sponge Motors and error compensation
 * - Enable Switch in Linearinterpolation, ManualControl and in Circularinterpolation (CW and CCW)
 * - Chalk & Sponge Arm Sensor
 * - Chalk Distance & Run out of Chalk Sensore
 * 
 **********************************************************************************************************************/

// Rechenvariablen
long XOld = 0;
long YOld = 0;
long XNew = 0;
long YNew = 0;
long XNewBreak = 0;
long YNewBreak = 0;
long XCircleDistance = 0;
long YCircleDistance = 0;
//int SteppsProMM = 1;
long XDistance;
long YDistance;
int Direction;
float ScaleFactor = 1.0;
int Linear = 0;

int Quadrant;
int DirA = 1;
int DirB = 2;

// Werkzeug
int ToolChoice = 1; // 1 = chalk, 2 = sponge

// Lesevariable
char CommandType1; 
int Command1;
char CommandType2; 
float Command2;
char CommandType3;
float Command3;
char CommandType4;
float Command4;
char CommandType5;
float Command5;

// Home and End Switch
int HomeXPin = A2;
int HomeYPin = A3;
int EndXPin = A4;
int EndYPin = A5;
int HomeX = HIGH;
int EndX = HIGH;
int HomeY = HIGH;
int EndY = HIGH;
int HomeXSteps = 0;
int HomeYSteps = 0;

// End and Home Correction
long YUpCorrection = 0;
long YDownCorrection = 0;
long XLeftCorrection = 0;
long XRightCorrection = 0;

// Sensors
int ChalkArmSensorPin = 2;
int SpongeArmSensorPin = 3;
int ChalkArmSensor = LOW;
int SpongeArmSensor = LOW;

int ChalkDistanceSensorPin = A0;
int ChalkDistanceSensor = 0;
int RunOutOfChalkPin = A1;
int RunOutOfChalk = LOW;

// Stepper Motor on the X-Axis
int ClockPin1=6;   // Clock1
int DirPin1=5;     // Direction1 CW/CCW
// Stepper Motor on the Y-Axis
int ClockPin2=11;   // Clock2
int DirPin2=12;     // Direction2 CW/CCW
// Stepper Motor Enable
int StepperEnablePin = 7;

int Speed=2000;
int Speed2=3000;

int SteppCheckY = 0;

// Motors
int ChalkMotor1Pin = 4;
int ChalkMotor2Pin = 13;
int ChalkDistanceMotorPin = 9;
int SpongeMotorPin = 8;
int SpongeDistanceMotorPin = 10;

void setup() {
  Serial.begin(9600);
  
  pinMode(ChalkMotor1Pin, OUTPUT);
  digitalWrite(ChalkMotor1Pin, LOW);
  pinMode(ChalkMotor2Pin, OUTPUT);
  digitalWrite(ChalkMotor2Pin, LOW);
  pinMode(ChalkDistanceMotorPin, OUTPUT);
  pinMode(SpongeMotorPin, OUTPUT);
  pinMode(SpongeDistanceMotorPin, OUTPUT);
  
  pinMode(RunOutOfChalkPin, INPUT_PULLUP);
  
  pinMode(HomeXPin, INPUT_PULLUP);
  pinMode(EndXPin, INPUT_PULLUP);
  pinMode(HomeYPin, INPUT_PULLUP);
  pinMode(EndYPin, INPUT_PULLUP);
  
  pinMode(ChalkArmSensorPin, INPUT_PULLUP);
  pinMode(SpongeArmSensorPin, INPUT_PULLUP);
  
  pinMode(ClockPin1, OUTPUT);
  pinMode(DirPin1, OUTPUT);
  pinMode(ClockPin2, OUTPUT);
  pinMode(DirPin2, OUTPUT);
  pinMode(StepperEnablePin, OUTPUT);
  digitalWrite(StepperEnablePin, LOW);
  
  digitalWrite(DirPin1, LOW);
  digitalWrite(ClockPin1, LOW);
  digitalWrite(DirPin2, LOW);
  digitalWrite(ClockPin2, LOW);

}

void loop() {
  DataControl();
}





