/***************************************************************
 * Home and End Button Control
 ***************************************************************
 *
 * reads the End- and Home-Buttons
 *
 ***************************************************************/


/***************************************************************/
// read the Home-and End-Buttons

void HomeEndButton(){
  HomeX = digitalRead(HomeXPin);
  EndX = digitalRead(EndXPin);
  HomeY = digitalRead(HomeYPin);
  EndY = digitalRead(EndYPin);
}

/***************************************************************/
// Waiting Possition X 5000 Y5000

void GoingForWait(){
  Command2 = 5000;
  Command3 = 5000;
  NewXY();
  LinearInterpolation();
}

/***********************************************************************************/
// Going to the old possition

void GoingBack(){
  XNew = XNewBreak;  // new possition is the saved possition
  YNew = YNewBreak;
  XOld = 100;       // old possition is the chalkpossition
  YOld = 5910;
  LinearInterpolation();
  ChalkArmControlDown();
}


/***************************************************************/
// Going to the Home Zone

void GoingHome(){ 
  digitalWrite(StepperEnablePin, HIGH); // turn on steppermotor
  delayMicroseconds(Speed);
  while (HomeY == HIGH) {
    HomeYSteps++;
    Stepp(4); //stepp down
  } 
  while (HomeX == HIGH) {
    HomeXSteps++;
    Stepp(3);   //stepp left
  }
  digitalWrite(StepperEnablePin, LOW); // turn off Motor
  delayMicroseconds(Speed);
  XOld = 0;
  YOld = 0;
}

/*******************************************************************/
// TURN EVERYTHING OFF

void EverythingOff(){
  SpongeArmControlUp();
  ChalkArmControlUp();
  ChalkSupplyMotorOff();
  digitalWrite(SpongeDistanceMotorPin, LOW);
  digitalWrite(SpongeMotorPin, LOW);
  digitalWrite(ChalkDistanceMotorPin, LOW);

  digitalWrite(StepperEnablePin, LOW);
  // reset all variables
  ScaleFactor = 1;
  ToolChoice = 1;
  Linear = 0;
  Direction = 1;  //stepp right
  YUpCorrection = 0;
  YDownCorrection = 0;
  XLeftCorrection = 0;
  XRightCorrection = 0;
  HomeXSteps = 0;
  HomeYSteps = 0;
  SteppCheckY = 0;
}







