/*********************************************************
 * Circular Interpolation 
 *********************************************************
 * 
 * Zeichnen eines Kreises unter Verwendung des Bresenham-Algorithmus zur Berechnung eines Achtelkreis.
 * - Unterscheidung in Uhrzeigersinn und gegen den Uhrzeigersinn
 * - Bestimmung der relative Position des Kreismittelpunktes zum Anfangs- und Endpunkt.
 * - Berechnen der entsprechend zu zeichnenden Kreisbo:gen
 * - Berechen der einzelnen Bo:gen
 * - Zeichnen der entsprechenden Teilbo:gen
 * - Endpunktkorrektur
 *********************************************************/

long XCircle; // X-Wert des Kreismittelpunktes
long YCircle; // Y-Wert des Kreismittelpunktes
long XKreis;  // Berechneter na:chster X-Wert des Kreise
long YKreis;  // Berechneter na:chster Y-Wert des Kreise
long Radius;
long Old_CenterQuadrant;
long New_CenterQuadrant;
int DrawCase = 3; // Indikator zum Zeichnen; 0=Zeichnen, 1=Anfangsbogen, 2=Endbogen, 3=nicht Zeichnen;

// Kreiszeichnen im Uhrzeigersinn
void CircularInterpolationCW(){
  digitalWrite(StepperEnablePin, HIGH); // turn on Motor
  delayMicroseconds(Speed);
  CalculateRadius();         // Radius und Mittelpunkt berechnen
  PositionCircleCenterCW();    // Position der Anfang- und Endpunkte zum Kreismittelpunkt bestimmen
  // entsprechend der Position des Kreismittelpunktes Bo:gen zeichnen
  switch (Old_CenterQuadrant){
  case 1:  // Kreismittelpunkt ist rechts oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle;// Anfangswerte setzten
    YKreis = YCircle - Radius;
    CircleCalculation(3,2);   // 5/6 Oktant => 3 Quadrant CW
    break;
  case 2:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle + Radius;// Anfangswerte setzten
    YKreis = YCircle;
    CircleCalculation(4,3);   // 7/8 Oktant => 4 Quadrant CW
    break;
  case 3:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle;         // Anfangswerte setzten
    YKreis = YCircle + Radius;
    CircleCalculation(1,4);   // 1/2 Oktant => 1 Quadrant CW
    break;
  case 4:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle - Radius;// Anfangswerte setzten
    YKreis = YCircle;
    CircleCalculation(2,1);   // 3/4 Oktant => 2 Quadrant CW  
    break;
  }
  XOld = XNew;  // Am Ende neuen Anfangspunkt setzen
  YOld = YNew;
  digitalWrite(StepperEnablePin, LOW); // turn off Motor
  //delayMicroseconds(Speed);
}

// Kreiszeichnen gegen den Uhrzeigersinn
void CircularInterpolationCCW(){ 
  digitalWrite(StepperEnablePin, HIGH); // turn on Motor
  delayMicroseconds(Speed);
  CalculateRadius();         // Radius und Mittelpunkt berechnen
  PositionCircleCenterCCW();    // Position der Anfang- und Endpunkte zum Kreismittelpunkt bestimmen
  // entsprechend der Position des Kreismittelpunktes Bo:gen zeichnen
  switch (Old_CenterQuadrant){
  case 1:  // Kreismittelpunkt ist rechts oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle - Radius;// Anfangswerte setzten
    YKreis = YCircle;
    CircleCalculation(4,1); // 5/6 Oktant CCW => 3 Quadrant CCW
    break;
  case 2:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle;// Anfangswerte setzten
    YKreis = YCircle - Radius;
    CircleCalculation(1,2);   // 7/8 Oktant CCW => 4 Quadrant CCW
    break;
  case 3:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle + Radius;         // Anfangswerte setzten
    YKreis = YCircle;
    CircleCalculation(2,3); // 1/2 Oktant CCW => 1 Quadrant CCW
    break;
  case 4:  // Kreismittelpunkt ist links oberhalb des Ausgangspunktes
    DrawCase = 1;             // Einstellung fu:r Anfangsbogen zeichnen
    XKreis = XCircle;// Anfangswerte setzten
    YKreis = YCircle + Radius;
    CircleCalculation(3,4); // 3/4 Oktant CCW => 2 Quadrant CCW   
    break;
  }
  XOld = XNew;  // Am Ende neuen Anfangspunkt setzen
  YOld = YNew;
  digitalWrite(StepperEnablePin, LOW); // turn off Motor
  //delayMicroseconds(Speed);
}

// Bestimmung der Position des Kreismittelpunktes in Bezug zum Anfang- und End-Punkt
// 1 = erster Quadrant, 2 = zweiter Quadrant, 3 = dritter Quadrant, 4 = vierter Quadrant
void PositionCircleCenterCW(){
  // in Bezug zum Anfangspunkt
  if ((XCircleDistance >= 0) && (YCircleDistance > 0)) Old_CenterQuadrant = 1;
  else if ((XCircleDistance < 0) && (YCircleDistance >= 0)) Old_CenterQuadrant = 2;
  else if ((XCircleDistance <= 0) && (YCircleDistance < 0)) Old_CenterQuadrant = 3;
  else if ((XCircleDistance > 0) && (YCircleDistance <= 0)) Old_CenterQuadrant = 4;
}
// gegen den Uhrzeigersinn andere Nullstellen
void PositionCircleCenterCCW(){
  // in Bezug zum Anfangspunkt
  if ((XCircleDistance > 0) && (YCircleDistance >= 0)) Old_CenterQuadrant = 1;
  else if ((XCircleDistance <= 0) && (YCircleDistance > 0)) Old_CenterQuadrant = 2;
  else if ((XCircleDistance < 0) && (YCircleDistance <= 0)) Old_CenterQuadrant = 3;
  else if ((XCircleDistance >= 0) && (YCircleDistance < 0)) Old_CenterQuadrant = 4;
}

//Berechnung des Radiuses und des Kreismittelpunktes
void CalculateRadius(){
  // Berechen des Radius aus den Dreieckschenkeln
  Radius = sqrt(XCircleDistance*XCircleDistance + YCircleDistance*YCircleDistance);
  // Berechnen des Kreismittelpunktes
  XCircle = XOld + XCircleDistance;
  YCircle = YOld + YCircleDistance;
}

// Bresenham-Algorithmus für einen Achtelkreis, mit gegebenen Radius.
// Der zweite Oktanten ergiebt sich durch Vorzeichenwechsel in dx und dy und Rollenvertauschung von x und y.
void CircleCalculation(int DirectionA, int DirectionB){
  int x = Radius;
  int y = 0;
  int RadiusError = Radius;
  // Erster Oktant
  do{  // Schleife: immer ein Schritt in schnelle Richtung (y), hin und wieder auch einen in die langsame Richtung
    // Ein Schritt in die schnelle Richtung
    int dy = y*2+1; 
    RadiusError = RadiusError-dy;
    y = y+1;
    DrawLimitationFast(DirectionA);
    if (RadiusError<0) {
      // ein Schritt in die langsame Richtung (hier negative x-Richtung)
      int dx = 1-x*2;
      RadiusError = RadiusError-dx;
      x = x-1;
      DrawLimitationSlow(DirectionB);
    }
  } 
  while (y<x);
  // Zweiter Oktant
  do{  // Schleife: immer ein Schritt in schnelle Richtung (y), hin und wieder auch einer in die langsame Richtung
    // Ein Schritt in die schnelle Richtung
    int dx = 1+x*2;
    RadiusError = RadiusError-dx;
    x = x-1;
    DrawLimitationFast(DirectionB);
    if (RadiusError<0) {
      // ein Schritt in die langsame Richtung (hier negative x-Richtung)
      int dy = -y*2-1; 
      RadiusError = RadiusError-dy;
      y = y+1;
      DrawLimitationSlow(DirectionA);
    }
  } 
  while ((x>0)&&(y>0));
}

// Erst mit Zeichnen anfangen, wenn XOld mit dem Ausganspunkt XKreis u:bereinstimmt.
// Enden wenn der Endpunkt erreicht ist, XKreis = XNew

// Auf den "schnellen" Wert schauen, entsprechend zeichnen und schalten
void DrawLimitationFast(int DirectionAB){
  switch (DrawCase){
  case 0:                // Einfach zeichen
    Stepp(DirectionAB);
    break;
  case 1:                // Anfangs Teilbogen zeichene
    if ((DirectionAB == 1) || (DirectionAB == 3)){ // bei einer Bewegung entlang der X-Achse:
      if (XKreis == XOld){
        DrawCase = 2;          // Beim Erreichen des Anfangs-X-Wertes Zeichnen beginnen
        Stepp(DirectionAB); 
      }
    }
    else if ((DirectionAB == 2) || (DirectionAB == 4)){ // bei einer Bewegung entlang der X-Achse:
      if (YKreis == YOld){
        DrawCase = 2;            // Beim Erreichen des Anfangs-X-Wertes Zeichnen beginnen 
        Stepp(DirectionAB);
      }
    }
    break;
  case 2:                // End Teilbogen zeichnen
    Stepp(DirectionAB);
    if ((DirectionAB == 2) || (DirectionAB == 4)){
      if (XKreis == XNew){                         // Beim Erreichen des End-X-Wertes Zeichnen beenden 
        //Korrektur();
        DrawCase = 3;
      }
    }
    else if ((DirectionAB == 1) || (DirectionAB == 3)){
      if (YKreis == YNew){                         // Beim Erreichen des End-X-Wertes Zeichnen beenden 
        //Korrektur();
        DrawCase = 3;
      }
    }
    break;
  case 3:                 // nicht Zeichnen
    break;
  }
  CountMovement(DirectionAB);                     // Schritte za:hlen
  //Debug();  
}

// auf den "langsamen" Wert schauen, entsprechend Zeichnen, sonnst nicht reagieren
void DrawLimitationSlow(int DirectionAB){
  CountMovement(DirectionAB);                     // Schritte za:hlen
  if (DrawCase == 0)  Stepp(DirectionAB);
  else if (DrawCase == 2) Stepp(DirectionAB);
  //DebugS();
}

// Za:hlen der berechneten Kreisschritte
// Schritt 1 = right, Schritt 2 = up, Schritt 3 = left, Schritt 4 = down
void CountMovement(int DirectionAB){
  switch(DirectionAB){
  case 1: // Schritt 1 = nach rechts
    ++XKreis;
    break;
  case 2: // Schritt 2 = nach oben
    ++YKreis;
    break;
  case 3: // Schritt 3 = nach links
    --XKreis;
    break;
  case 4: // Schritt 4 = nach unten
    --YKreis;
    break;
  }
}

// Korrektur des Endpunktes. Der Ungenauigkeit entsprechen 1,2 Schritte hinzufu:gen
void Korrektur(){
  if (YKreis < YNew) {
    for (int j=0; j<(YNew-YKreis); j++) Stepp(2); // nach oben
  }
  else if (YKreis > YNew){
    for (int j=0; j<(YKreis-YNew); j++) Stepp(4); // nach unten
  }
  if (XKreis < XNew) {
    for (int j=0; j<(XNew-XKreis); j++) Stepp(1); // nach rechts
  }
  else if (XKreis > XNew) {
    for (int j=0; j<(XKreis-XNew); j++) Stepp(3); // nach links
  }
}



















