/*Simple Audio Player for Arduino MKR Zero

  Demonstrates the use of the Audio library for the Arduino MKR Zero

  Hardware required :
   SD card on CS28
   A sound file named "test.wav" in the root directory of the SD card
   (44100kHz stereo, 8-bit unsigned PCM)
   An audio amplifier to connect to the DAC0 and ground

  Arturo Guadalupi <a.guadalupi@arduino.cc>
  Angelo Scialabba <a.scialabba@arduino.cc>
  Claudio Indellicati <c.indellicati@arduino.cc>
  Wolfgang Spahn <post@dernulleffekt.de>

  This example code is on:
  http://dernulleffekt.de/doku.php?id=arduino:arduino_mkrzero
*/

#include <SD.h>
#include <SPI.h>
#include <AudioZero.h>

void setup()
{
  // debug output at 115200 baud
  Serial.begin(115200);
  // setup SD-card
  delay(500); // wait until the serial connection is set up
  Serial.print("Initializing SD card...");
  if (!SD.begin(28)) {
    Serial.println(" failed!");
    while (true);
  }
  Serial.println(" done.");

  // 44100kHz stereo => 88200 sample rate
  AudioZero.begin(2*44100);
}

void loop()
{
  // open wave file from sdcard
  Serial.print("Opening File!");
  File myFile = SD.open("test.wav");
  if (!myFile) {
    // if the file didn't open, print an error and stop
    Serial.println("error opening test.wav");
    while (true);
  }

  Serial.print("Playing!");

  // until the file is not finished
  AudioZero.play(myFile);
  Serial.print("Attention Noise!");
  while (true);
}
